//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Dyeable Fire (Creator)
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// This is just the script that allows the fire to be turned into dyeable fire by right clicking it with a dye. No configs available here.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Dye to State Mapper
const dyeToState = {
	"minecraft:white_dye": 0,
	"minecraft:orange_dye": 1,
	"minecraft:magenta_dye": 2,
	"minecraft:light_blue_dye": 3,
	"minecraft:yellow_dye": 4,
	"minecraft:lime_dye": 5,
	"minecraft:pink_dye": 6,
	"minecraft:gray_dye": 7,
	"minecraft:light_gray_dye": 8,
	"minecraft:cyan_dye": 9,
	"minecraft:purple_dye": 10,
	"minecraft:blue_dye": 11,
	"minecraft:brown_dye": 12,
	"minecraft:green_dye": 13,
	"minecraft:red_dye": 14,
	"minecraft:black_dye": 15
}

// Right Click
BlockEvents.rightClicked(event => {
    const player = event.getEntity();
    const server = player.getServer();

    if (event.getBlock().getId() === "minecraft:fire" || event.getBlock().getId() === "minecraft:soul_fire" || event.getBlock().getId() === "pa2_extras:dyeable_fire")
	{
		if (event.getItem().hasTag("forge:dyes"))
		{
			let stage = dyeToState[event.getItem().getId()];
			
			if (event.getBlock().getId() === "pa2_extras:dyeable_fire" && stage === event.getBlock().getBlockState().getValue(BlockProperties.AGE_15))
				return;
			
			let pos = `${event.getBlock().getX()} ${event.getBlock().getY()} ${event.getBlock().getZ()}`;			
			server.runCommandSilent(`setblock ${pos} pa2_extras:dyeable_fire[age=${stage}]`);
			
			if (!event.getEntity().creative)
				event.getItem().shrink(1);
		}
	}
})